% addpath(genpath('M:\PhD\BramVanthoorModelVer2'));
% addpath(genpath('M:\PhD\Models\StateSpaceModel'));
% cd('M:\PhD\BramVanthoorModelVer2\Code');

setPointAdd = 0.5; % choose 0 or 0.5

simType = 'hps';
filter = 'none';
simRes = 1; ctrlRes = 300; % step size when solving [s] 

scenStart = 1;  % up to 18
scenEnd = 1;

numSim = scenEnd-scenStart+1;
saveTo = ['energyUse_' simType '__manuscriptParams_' num2str(scenStart) '-' num2str(scenEnd)];


seasonLength = 112; % 125; % season length in days (data length is 126 days, 112 if you need co2 injection)
firstDay = 1; %15*ones(1,numSim); % days since beginning of data        

fprintf('saving to %s\n', saveTo);

bv(numSim,1) = StateSpaceModel;

[outdoor, indoor, controls, startTime] = loadGreenhouseData(firstDay, seasonLength, simType, filter);

indoor(:,3) = vaporDens2pres(indoor(:,2), indoor(:,3));
        % convert vapor density to vapor pressure

indoor(:,4) = 1e6*co2ppm2dens(indoor(:,2),indoor(:,4));
        % convert co2 from ppm to mg m^{-3}

secsInYear = seconds(startTime-datetime(year(startTime),1,1,0,0,0));
    % number of seconds since beginning of year to startTime

outdoor(:,7) = skyTempRdam(outdoor(:,3), datenum(startTime)+outdoor(:,1)/86400); % add sky temperature
outdoor(:,8) = soilTempNl(secsInYear+outdoor(:,1)); % add soil temperature

for n=1:numSim
    bv(n) = createBvModel(outdoor, startTime, controls, indoor);
    feval(['set' upper(simType(1)) simType(2:end) 'Params'], bv(n));
    bv(n).p.simRes.val = simRes; 

    % don't load pipe temperature data
    bv(n).d.tPipe.val(:,2) = zeros(size(bv(n).d.tPipe.val(:,2)));
    bv(n).d.tGroPipe.val(:,2) = zeros(size(bv(n).d.tGroPipe.val(:,2)));

    bv(n).d.heatSetPoint = DynamicElement('d.heatSetPoint', indoor(:,1:2));

    % dummy variable to ensure the definition of u.boil is correct
    x.tAir = DynamicElement('x.tAir',bv(n).x.tAir.val);
    
    % Heating from boiler [0 is no heating, 1 is full heating]
    
    bv(n).u.boil = proportionalControl(x.tAir, bv(n).d.heatSetPoint+setPointAdd, bv(n).p.tHeatBand, 0, 1);
    
    bv(n).u.boil.val = [];

    bv(n).u.groBoil = DynamicElement(bv(n).u.boil);
    
    bv(n).p.pBoil.val = 125*bv(n).p.aFlr.val;
    bv(n).p.pGroBoil.val = 125*bv(n).p.aFlr.val;
    
    setParam(bv(n),'cLeakage', 3e-5);
    setParam(bv(n),'aRoof', 52.2);

    setParam(bv(n),'kBlScr',5e-4);

    setParam(bv(n),'kThScr',5e-4);

    setParam(bv(n), 'cWgh', 0.02); % default is 0.09
    setParam(bv(n), 'cDgh', 0.35); % default is 0.75

    bv(n).x.cLeaf.val = 0.7*6240*10;
    bv(n).x.cStem.val = 0.25*6240*10;
    bv(n).x.cFruit.val = 0.05*6240*10;

    setParam(bv(n), 'cHecIn', 3.5);
end


for n=1:numSim
    seasonLength = bv(n).t.val(2)/86400; % season length in days, after filtering

    timer = tic;
    fprintf('(%d of %d) Start time: %s; Estimated run time: %s; ETA: %s\n', ...
        n, numSim, datetime('now'), datestr(seconds(seasonLength*90), 'HH:MM:SS'), ...
        datestr(datetime('now')+seconds(seasonLength*90)));
%     
    
    odeSolve(bv(n), 'ode15s', []);
    
    fprintf('Actual run time: %s; End time: %s\n', ...
         datestr(seconds(toc(timer)), 'HH:MM:SS'), datetime('now'));

    bv(n) = changeRes(bv(n),300);

    bv(n).d.tPipe.val(:,2) = controls(:,5);
    bv(n).d.tGroPipe.val(:,2) = controls(:,6);

    % calculate energy input from data
    bv(n).d.uPipe = DynamicElement('d.uPipe', ...
        [bv(n).d.tPipe.val(:,1), pipeEnergy(controls(:,5)-indoor(:,2))]);

    bv(n).d.uGroPipe = DynamicElement('d.uGroPipe', ...
        [bv(n).d.tPipe.val(:,1), groPipeEnergy(controls(:,6)-indoor(:,2))]);

    plot(cumsum(bv(n).a.hBoilPipe+bv(n).a.hBoilGroPipe));
    hold on
    plot(cumsum(bv(n).d.uPipe+bv(n).d.uGroPipe));
    legend('simulated','calculated from data');

    eMeas(n) = 1e-6*trapz(bv(n).d.uPipe+bv(n).d.uGroPipe);
    eSim(n) = 1e-6*trapz(bv(n),bv(n).a.hBoilPipe+bv(n).a.hBoilGroPipe);
    ratio = eSim./eMeas;
    
    save(saveTo);
end

beep